#if 1
#include <cstdio>
#include <cstring>
#include <cassert>
#include <iostream>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <stack>
#include <queue>
#include <algorithm>
using namespace std;

#define pb push_back
#define mp make_pair
#define X first
#define Y second

typedef long long li;
typedef long double ld;
typedef pair<int,int> pii;
typedef vector<int> vi;
typedef vector<vi> vvi;

int n, m;
vvi g, w, id;
const int inf = 2e9 + 7;
void dijkstra(int s, vi &dist)
{
	dist.assign(n, inf);
	dist[s] = 0;
	set<pii> q;
	q.insert(mp(0, s));
	while(q.size())
	{
		pii now = *q.begin();
		q.erase(q.begin());
		if(now.first != dist[now.second]) continue;
		for (int i = 0; i < g[now.second].size(); ++i)
		{
			int to = g[now.second][i];
			if(now.first + w[now.second][i] < dist[to])
			{
				dist[to] = now.first + w[now.second][i];
				q.insert(mp(dist[to], to));
			}
		}
	}
}

vector<int> tin, fup;
vector<int> ans;
map<pii, int> cnt;
map<pii, int> W;
void dfs(int v, vvi &g, vvi &id, int p, int time)
{
	tin[v] = time++;
	fup[v] = tin[v];
	for (int i = 0; i < g[v].size(); ++i)
	{
		int to = g[v][i];
		if(to == p) continue;
		if(!tin[to])
		{
			dfs(to, g, id, v, time);
			fup[v] = min(fup[v], fup[to]);
		}
		else fup[v] = min(fup[v], tin[to]);

		if(fup[v] < fup[to] && (cnt[mp( min(v,to), max(v,to) )] == 1)) 
			ans.push_back(id[v][i]);
	}
}

struct edge
{
	edge() {}
	edge(int a, int b, int t) : a(a), b(b), t(t) {}
	int a, b, t;
};

int main()
{
#ifdef _DEBUG
	freopen("input.txt", "r", stdin);
#endif
	cin >> n >> m;
	g.resize(n);
	w.resize(n);
	id.resize(n);
	vector<edge> E(m);
	for (int i = 0; i < m; ++i)
	{
		int a, b, t;
		cin >> a >> b >> t;
		--a; --b;
		E[i] = edge(a, b, t);
		pii e = mp(min(a, b), max(a, b));
		if(t < W[e])
		{
			W[e] = t;
			cnt[e] = 1;
		}
		else cnt[e]++;
	}

	for (int i = 0; i < m; ++i)
	{
		int a, b, t;
		a = E[i].a;
		b = E[i].b;
		t = E[i].t;
		g[a].push_back(b);
		w[a].push_back(t);
		g[b].push_back(a);
		w[b].push_back(t);
		id[a].push_back(i + 1);
		id[b].push_back(i + 1);
	}
	vi dist1, dist2;
	dijkstra(0, dist1);
	dijkstra(n-1, dist2);
	if(dist1[0] != inf)
	{
 		vvi newg(n), newid(n);
		for (int i = 0; i < g.size(); ++i)
		{
			for (int j = 0; j < g[i].size(); ++j)
			{
				int to = g[i][j];
				int d1 = dist1[i] + w[i][j] + dist2[to];
				int d2 = dist2[i] + w[i][j] + dist1[to];
				if(min(d1, d2) == dist2[0])
				{
					newg[i].push_back(to);
					newid[i].push_back(id[i][j]);
				}
			}
		}
		tin.assign(n, 0);
		fup.assign(n, 0);
		int time = 1;
		for (int i = 0; i < n; ++i)
		{
			if(tin[i]) continue;
			dfs(i, newg, newid, -1, time);
		}

	}
	cout << ans.size() << endl;
	sort(ans.begin(), ans.end());
	for (int i = 0; i < ans.size(); ++i) cout << ans[i] << ' ';
	return 0;
}
#endif